---
title: "What is the futur of the Lock mechanism in PLM ?"
date: 2018-09-11
categories: 
  - "ui-ux"
coverImage: "padlock-lock-chain-key-39624.jpeg"
---

The lock mechanism is a key element in all collaboration software. It's the little button that allows to make sure you are the only one editing an item. usually locking an item means that you set a lock information on an item (part, document,...). As long as you have locked the item anyone who attempts to open the item has an indicator preventing this person to set the form as editable.

If you think API, the lock mechanism also has to prevent any execution of an edit query which wouldn't be done by the user locking the object. Then it is not only a user interface thing, it is also a real back-end mechanism.

Following is a list of examples of different item types that have been provided without locks through some specific technologies.

## Document

In recent years we have seen more and more solutions allowing to do live collaboration on items like documents. Google doc was the first large implementation that I could remember of an enterprise editing system which would allow to have live collaboration of documents. There is no locking mechanism and even the save button disappear as any change is saved live.

https://www.youtube.com/watch?v=-qTcDsbvbjk

## Structured content

I even built a product a few years ago: [minuteez.com](http://minuteez.com/#). It would allow to create structured content with real time collaboration. This is an advanced step compared to Google doc, where the doc itself is the main granularity, whereas here the document contains some granularity which could be reused and browsed in other interfaces.

https://www.youtube.com/watch?v=LkP25tVRyAw

For those who are interested in the technology, this actually used an online service called Firebase which allows live collaboration (the server updating the clients via a socket).

- [https://firebase.google.com/](https://firebase.google.com/)

You can also have a library for your nodeJs server :

- [https://socket.io/](https://socket.io/)

## Software source code

I didn't start with this one but the software industry has fixed the lock mechanism a long time ago by enabling collaboration with source code control. Some of these system allowed to log certain file but basically the concept is that people could write the same files at the same time and a merge would be done when necessary to handle the potential conflicts.

Here is a nice introduction video to Git which is by far the most used source code control software:

https://www.youtube.com/watch?v=uR6G2v\_WsRA

## Mechanical CAD

To get even more far with PLM/PDM context, this concept needed to be applied to CAD. Merging CAD is more complex then source code. Git does it on a line by line basis. Merging CAD really depends on the file supporting the geometry definition. Some companies have tried to rely on standards like STEP to allow merging files. The latest technology allowing branch and merging and real-time collaboration is available in [OnShape](https://www.onshape.com/). The Cloud-only CAD solution.

https://www.youtube.com/watch?v=QHEKB2tO4-8

https://www.youtube.com/watch?v=IZr1YhxHyMo

# What is the future then?

I was just sitting close to a PLM training where some people were confused about the lock mechanism. It seems obvious for most of the experience PDM/PLM users but it is not that obvious for new comers. So should we just believe that it is something to be trained on? or do we follow the latest trends like google docs where multiple people as long as they have the correct permission can access an information without having to lock it?
