---
title: "Going to GraphConnect 2018"
date: 2018-09-19
categories: 
  - "databases"
  - "technological-stack"
coverImage: "2018-09-19-07.11.44.jpg"
---

![NYC workplace](images/2018-09-19-06.44.43-e1537371427348-186x300.jpg)Looking at the picture you can tell that I am in the NYC area to attend [GraphConnect](https://graphconnect.com/#about) 2018.

GraphConnect is a major conference organized by Neo4J, the graph database. During a bit more than 2 days (there is a hackathon on saturday) talks and conferences will be held on how graphs can be used in a wide range of contexts. As a disclaimer,I am going there for [Graphileon, a software/framework that allows to create applications as graphs](https://graphileon.com/).

 

# Graph databases

Graphs eat the world, that's the tag line when you become a graph enthusiast. When you work with databases, you have a few main types of databases. When I started software development, the norm was to start with PHP&MySql. Then, I got in PLM and every software was based on SQL server databases.

There are many database technologies these days. In relationship with PLM, I have tried document DB, which were limited when querying structures. I also tried [native XML databases](http://basex.org/) because most of the data-standards are described in XML and Xquery offers great ways to navigate data structure. But graph databases have a powerful messaging: "your data is a graph". Very easy to communicate to anyone one new to a domain.

Just draw the following graph, and it is pretty easy to seduce people on the concept that storing data as a graph will optimize data search on link navigation.

![plmgraph](images/plmgraph.png)

Of coure this is an over-simplistic and reduced model, some people will ask to have a real node as a part-bom, blablabla, that's not the point. The point is links in PLM are crucial, and optimizing storage on links is a seducing concept.

# Neo4j

Neo4j is by far the database that has succeeded to communicate well on graph databases. Their graphconnect conference will gather about 1000 people in downtown NYC this year. Most of their communication these last few years has been done on fraud detection and the panama papers. But lots of various areas have been explored.

I started following it when Robert Scobble did a video interview of Emil Eifrem explaining why graphs database were the future :

https://www.youtube.com/watch?v=2ElGO1P8v0c

## The power of Cypher

The first enabling point for getting into Neo4j was the possibility to download the solution and make a quite extensive use of it without much effort. The key concept was for me the query language called Cypher.

Here is an example that creates a "Person" node with some parameters.

```
CREATE (ee:Person { name: "Emil", from: "Sweden", klout: 99 })
```

And here is a simple pattern matching example:

```
MATCH (ee:Person)-[:KNOWS]-(friends)
WHERE ee.name = "Emil" RETURN ee, friends
```

And today, [openCypher](https://www.opencypher.org/) has emerged in order to provide a standard graph query language which could be applied as a layer on top of any db technology. Only the performances would differ then.

## Other graph databases?

Here is a quick list of other graph databases. I don't have much info about them.

- [memgraph](https://memgraph.com/)
- [TigerGraph](https://www.tigergraph.com/)

# What is the relationship with PLM stack?

The whole concept of PLM stack is to study every brick of a PLM system to see what can fuel the whole PLM platform.

In the context of PDM/PLM, Dr Andreas Weber made a presentation about the usage of Neo4j graph database at a toy manufacturer.

https://www.youtube.com/watch?v=pFRCdi0CvJA

[The whole blog post is here](https://neo4j.com/blog/semantic-pdm-graph-data-model-schleich/)

I will attend the conference and will come back with another article about graph databases applied to PLM. The goal is to have a better understanding of:

- Positionning of graph databases along with classic SQL server in PLM
- Scaling capabilities
