---
title: "Front-end frameworks"
date: 2019-01-23
categories: 
  - "software-solutions"
coverImage: "websitefrontdesign.png"
---

PLM solutions are mostly web-based nowadays. To access the main User Interface of these PLM solutions you need a web-browser. Web browers are eating 3 languages:

- HTML
- CSS
- Javascript

The XML purist wanted to have only HTML and CSS. But the W3C consortium acknowledged that the javascript opportunity was too big for the web and encouraged web browsers to support it.

User Interfaces and User Experiences (UI/UX) are key for a correct long terme usage of a PLM Platform. UI/UX is a whole area of expertise. And on a specific job basis, you can also have very specific UI/UX requirements. That's why I believe the front-end framework should be a specific lego block to take into account when building a PLM stack. Let the configuration management specialist build a great API and then build or buy job-specific UI/UX.

A few years ago, front-end javascript frameworks were poping up every month. Now we are in a stabilization phase were the leading frameworks are identified but their pace of development is still very fast.

## What is front-end development ?

If I lost you here is a great video about front-end development and frameworks

https://www.youtube.com/watch?v=Xd7huBu39qk

## Which Javascript Framework?

Some of the large customer I visited these last few month are looking into building job-specific UIs. And from the development teams, I see mainly requests to develop UIs with [Angular](https://angular.io/). Here are the main front-end frameworks used these days:

- [React](https://reactjs.org/)
- [Angular](https://angular.io/)
- [Vue.js](https://vuejs.org/)

There are others frameworks, but these days, these 3 are really the ones for which you will have lots of support on the web and a wide range of libraries and modules to build pretty much anything.

Sadly, I think none of the existing PLM solution on the market uses these frameworks. Some editor will tell you that these frameworks are moving too fast compared to the PLM industry where you need to design a solution for the next 10-15 years.

Again if you want a good and agile PLM stack. Split the concerns. Front-end development is a real job and expertise. make sure this is well split with other concerns like configuration management, database,...
