---
title: "Should you care about the programing language used in your PLM stack?"
date: 2019-10-11
categories: 
  - "software-solutions"
  - "technological-stack"
coverImage: "business-code-coding-270360.jpg"
---

What is the language your PLM solution has been built with? It is something that barely comes up in PLM evaluation. Does it matter? I think so, but in order to know why it matters you need to understand and evaluate the different consequences of the programming language selection. You won't have the choice of programming language once you select a PLM. And it might not occur to you that the language impacts your PLM project but it does.

### Development Resources

The thing that I find the most interesting about programming is the resources. What if you find a very flexible PLM solution on the market which was developed in Pascal? If you don't need to do any customisation you may already have an issue with support obsolescence from the editor. But if you need to work on advanced customisation it might be interesting to evaluate the size of population where you could find resources.

Here is an interesting data visualisation video showing you how languages popularity changed over the last 50+ years.

https://www.youtube.com/watch?v=Og847HVwRSI

### Javascript as the web standard

As most of you may know, the client side of the web (what comes in your browser to generate a nice user interface) is HTML + CSS + Javascript. HTML being more a descriptive language and CSS a styling language, the programming language is Javascript. Let's be clear, it's 2019 ! Your PLM has to be a web solution. Good thing is, you won't have a fight of the editors about the use of javascript client side.

### Which programming language for what ?

Here is a nice list of [languages from a question on Quora where it describes what it's best for](https://www.quora.com/Which-programming-languages-are-used-for-what):

- **Java** — mainly web, mobile, desktop
- **Python** — mainly data science, machine learning, Internet of Things, numerical and financial computing
- **JavaScript** — mainly for front-end web development
- **C++** — mainly for high-performance computing such as video games, graphics, numerical computing; its little brother, C, is used for systems programming (operating systems device drivers, embedded)
- **C#** — mainly for Windows (.NET) programming
- **Ruby** — mainly for server-side web development (Rails)
- **Perl** — mainly for scripting, server-side web development
- **PHP** — mainly for server-side web development
- **Groovy** — mainly for server-side web development (Grails)
- **Scala** — mainly for server-side web development (Play), cloud computing, data science, machine learning
- ...

Seen from the perspective of the application:

- **WEB**: languages that deal with programming things that then live on the web. These can be client-side or server side. Websites, web apps, etc. A few examples: Javascript, PHP, Ruby, Python.
- **Desktop**: languages that are traditionally used to create applications for desktop machines for a specific operating system. A few examples: Java, C, C++, C#, Swift.
- **Mobile**: languages that are typically used to program apps for mobile operating systems. A few examples: Swift, Java, Kotlin.
- **Database languages**: these tend to deal strictly with data manipulation in small or large databases. For instance: SQL, XML, JSON.
- **Visualisation languages**: used for visualizing large quantities of data so it’s easier to understand. One that I briefly dealt with was: R.
- **Artistic purpose languages**: these are few and far between, but Chuck is an interesting one to look at if you like music and sound.
- **Gaming languages**: I personally never did game programming but the languages to be used are: C, C++, Java, Swift, Javascript (and more).
- **Multipurpose languages**: there will often be an overlap as to what a language can be used for. Some, like Javascript, Python, Swift, Java, XML and JSON (and many more), can be used for at least 3–4 purposes in this list

So how does a PLM application fit in these application type. We already said that today a PLM solution has to be a web solution. So it can actually be a good fit with multiple languages, the main need for PLM is to accept a large number of users and to integrate with various authoring tools. So scalability and API capabilities are good things to look for.

But once again, the main importance of the language is its popularity in order to know how many people will be able to apply for working on your system. I've seen customers fighting to find an [APL](https://en.wikipedia.org/wiki/APL_\(programming_language\)) developer !!! Make sure you start with a programming language that has a long lifetime ahead of it.

### My personal taste

I like Javascript and I like the fact that it is available not only client side but also server side now with [node.js](https://nodejs.org/en/). So if you have a full application in Javascript a single javascript developer can understand the whole application.

#### What's you preferred programming language?
