---
title: "is Open Source PLM Doomed?"
date: 2019-12-12
categories: 
  - "business-model"
  - "software-solutions"
coverImage: "Open_Source_Initiative_keyhole.svg_.png"
---

I just stumbled upon a video from CNBC just yesterday about the rise of Open Source.

https://www.youtube.com/watch?v=SpeDK1TPbew

It gave me a strange reaction at first. Open source is getting bigger every day. NPM packages (or NuGet, PyPi,...) are getting downloaded millions of times every day containing a majority of open source code. But it is not like Open Source is a new success, I even feel like the fever of open source went down (at least the growth slew down) when SaaS business models came in. I like to compare SaaS/Open Source in software with Netflix/Torrent for videos. Many services you don't need the code itself anymore you just need the service.

![](images/npmvsblackhole.jpg)

The goal of this article is not to discuss the pros and cons of Open Source, but to try to understand why Open Source is still on the rise in many areas of the software industry but not in the PLM Business.

## The Open Source PLM solutions

First let's take a look at the existing PLM solutions with a quick Google Search for "Open Source PLM"

- OpenPLM
- BeCPG (based on Alfresco)
- Alexia

Open PLM was a french Open Source PLM project. Last update was 5 years ago. So we can declare it a dead project. It was using the Django framework (python). [http://www.openplm.org/trac/browser](http://www.openplm.org/trac/browser)

[BeCPG](http://www.becpg.fr/) is a customisation of Alfresco. The sources are available on source forge, but the last community version is from June 2018. \[Edit on December 20th, 2019: message from one of BeCPG founder "Our software is still open source and still active. Developer can still download and build beCPG with latest sources.Our last version on source forge is from june 2018 because we were quite busy these last months due to client projects.  
We had release several versions since june 2018 but they are not on source forge.We will release a new version on source forge beginning of 2020 that is compatible with the last Alfresco version 6.2 and we will be more active with our community in 2020."\]

Finally [Alexia](http://alexiaplm.org/download.php) was a PLM project I remember was launched in a linkedin group. But never really got started.

## Why PLM and Open Source don't go along?

First of all, if we look at all the open source libraries. Very few libraries actually get massively maintained. It requires a lot of developers and users to maintain some sort of hype on a project to get people really interested in it. That's a first issue. PLM is a niche, there aren't enough tech dev and users to keep the hype.

The other PLM open source category, is the marketing one. Companies develop their product and suddenly declare themselves open source by creating an Open Source version called "Community". It usually allows companies to download the software and play with it, but you don't get many people to actually look at the sources and collaborate on development.

Open source often talks to tech people. PLM is not a real tech environment. Software sales are not much based on the product technicality. It is more functional requirements and politics.

## No incentive to go Open Source

The last 10 years in PLM have shown that Open Source just bring a little bit of hype, but companies are not buying on hype, they buy on references. Also you won't get collaboration because there aren't enough developers in PLM.

## Conclusion

It may be a cold conclusion, but I don't see any reason for an Open Source PLM to succeed in the next decade! Hope you enjoyed the video though.
