---
title: "Has FFF Killed ?"
date: 2020-02-26
categories: 
  - "business-consulting"
coverImage: "triailCourt.jpg"
---

Wow, this blog took a dramatic 180° turn. Don't worry, this is still talking about PLM and more precisely about the Fit, Form, Function (and Safety for some companies) practice in configuration management.

## The big letal case

This case was actually brought to my attention by [Pascal Morenton](https://www.linkedin.com/in/morenton/) from [Centrale-Supelec](https://www.centralesupelec.fr/). (one of the great French Engineering School, for which I wasn't smart enough to attend). It was during a [BackToBasics](https://www.plmlab.fr/conferences-back-to-basics/) conference we organise in an association called [PLMLab](https://www.plmlab.fr/) in France. He mentioned a case where because a part change was just revised and not renumbered, it didn't warn anyone about a change in a car. Here is the link to the article which I suggest you take the time to read if you don't know the story.

- [Key GM crisis questions: Who approved switch revision and why recall took so long](https://www.reuters.com/article/gm-recall-part/key-gm-crisis-questions-who-approved-switch-revision-and-why-recall-took-so-long-idUSL1N0MQ0FK20140330)
- [A mistake at GM, and an important lesson in supplier quality management](https://www.1factory.com/blog-post-gm-recall.html)
- [GM Engineer OK'd No New Part Number in Ignition Switch Fix](https://www.nbcnews.com/storyline/gm-recall/document-gm-engineer-ok-d-no-new-part-number-ignition-n78566)

The consequence is that with this new Part, under certain level of vibrations (like in an accident), the ignition switch would turn off and deactivate the Airbags !

## What is the real configuration management issue?

I'm not trying to describe how we could have avoided this problem. At some point, whatever you do with renumbering things, unless you simulate every configuration under every condition, there are some particular dramatic events that will happen. The question is, how can we get better at getting a better attention to changes? Even when they are small, how can we make sure that we know the exact cause of any accident quickly? (as in the GM case, it took a long time to identify the cause and also to recall the impacted cars)

So here, the configuration management issue was the fact that two parts were defined as interchangeable when apparently under certain circumstances (high vibrations) they weren't.

## Should we stop hidding changes from Production?

Considering parts interchangeable when they actually aren't is an issue, but it is a human decision, so we cannot rely on having 100% decision correct, therefor, if any these decision can have letal impacts we need to find more poka-yoke-like systems to prevent a bad decision to be reaching the field.

The first problem we meet in the product lifecycle is hiding revisions when parts move from PLM to ERP.

## One possible solution: Never Revise once ordered or manufactured

The PLM-ERP integration is always a key aspect of a PLM project. The actual case at GM, is the consequence in the production and supply chain world of a bad decision in the PLM world. Then the answer could be in the interface between these two worlds. We often see in PLM parts having multiple lifecycle. A configuration lifecycle (Draft, Review, Release) and an industrial lifecycle (Proto, Production). What if you'd say, once a part reaches Production, you can't revise it anymore. Therefor you will have to create a new part for any change and you avoir errors in production (when production assumes revisions are interchangeable).

## My actual position: Don't hide versions

I would have a less technical rule. Don't hide versions, make sure any change rings a bell in the supply chain and in production. Or, assume the consequences and allow one of your chief engineer to go in jail for an ECO sign-off he has no memory of.

The issue again, is how many versions my parts will get if I'm not stopping the versions in my product evolution. I wrote a blog post a while ago about having different digits for versions. I'm a great supporter of the [Semantic Versioning](https://semver.org/) applied to all domains. I suggested a while ago to have versioning digits per domain. So whenever a change is made, by looking at a version change you could tell the type of change that occurred. It was just an idea. I would have to see how this could be applied and more importantly, if this would really bring value.

Now I actually tend to like the idea of not revising a part once it reached production state!

I actually had to explain a simple case for FFF yesterday. I'll write it in one of my next articles.
