---
title: "Who benefits from a multi-tenant PLM Stack?"
date: 2021-08-30
categories: 
  - "technological-stack"
coverImage: "massimo-botturi-zFYUsLk_50Y-unsplash.jpg"
---

There is a debate on cloud PLM stack. Some would argue that cloud PLM = SaaS PLM = Multi-tenant. Any discussion on this topic becomes quickly technical and looses 80% of the audience who wants a cloud PLM mainly for a lower cost of ownership and an easier adoption of the software. But I'll try to keep it short.

## PLM deployment options

Here is the traditional setup. You host your PLM application server and your database in-house.

![](images/onPremise1-1024x223.png)

Cloud PLM means having the PLM solution hosted in the cloud.

![](images/SaaS1-1024x220.png)

SaaS PLM means you get PLM as a Service and not as an Asset. Therefore you expect to pay a fee in regards to the service provided. It becomes more a business model than an actual technical implementation. You could be invoice based on a user count, or the software/service vendor could measure your usage of the platform (data stored, API calls, active users over 15 days, types of users,...) and invoice based on these metrics.

## Progressing towards multi-tenancy

Multi-tenant PLM, is an IT architecture which mainly covers two aspects of the PLM stack. It is about sharing the same server for multiple instances of a software. We don't talk about hardware as its mostly virtualized. The main components you could think of sharing are :

- the application server
- the database.

If we take two companies using their own PLM cloud instances. This can be a SaaS setup. Once again SaaS is technically enabled by the cloud but it is mainly a business model.

![](images/SaaS2-1024x460.png)

Here, each company can have its own configuration and its own data without risk (except from fraudulent usage) to have another company accessing their data.

Let's now suppose that they have the same provider who sets up a multi-tenant architecture for the Application Server:

![](images/SaaS3-1024x466.png)

In this setup the main takeaway is for the service provider who does not have to have a new server for each customer. The customer gets an "account" and we suppose that the service provider has some sort of automation to create a new database (could be on the same server). The application server would, based on the identification of each request, retrieve data from the correct database. Once again this gives a good separation of data from one customer to another. In most cases, you would lose some level of customisation, therefore most companies who built multi-tenant PLM applications had to have a standard PLM model. What's in it for the customer? Hopefully a lower cost of operation. Also the upgrade process should disappear as only one system is upgraded and would automatically upgrade all related databases.

In this last case we could push the multi-tenancy to the database.

![](images/SaaS4-1024x460.png)

In this situation every company could be on a same system, same application server and same database. The data segregation could be either done by marking the data with a company identifier or via a specific user access process. This setup would have the benefit of enabling an easier collaboration between employees from different companies.

## Challenges?

- The less you allow customisation of a PLM system the easier it might be to move to a full multi-tenant system. Then if you allow a high level of customisations, you need to put the right architecture and technology in place to support it with multi-tenancy.
- Everyone on a same database is a great challenge. Great by its difficulty but also great for the value it could bring. Everyone on a same database means less data-exchange, and more interaction on a single source of the truth. I believe graph databases will allow us to move toward such setup.

## Conclusion

I have had many contact with software editors looking to acquire a potential multi-tenant PLM solution. If you are starting a new solution, take this path. Find a standard PLM model, build a multi-tenant architecture with a nice user experience. With a few customers chances are that you get acquired by a larger editor. Working on Ganister we believe that flexibility is the first value companies need. The multitenant architecture will only reduce cost for the customer, not create value. In my opinion the single database is THE key challenge which would bring value to companies in there ability to collaborate.
