---
title: "PLM Recommendation Engine"
date: 2021-09-08
categories: 
  - "business-features"
  - "databases"
  - "general-plm"
  - "technological-stack"
coverImage: "recommendation.jpg"
---

As an enterprise-wide data management platform, one of the main PLM goal is to provide the users with the right data at the right moment. The digital thread should provide a continuity to easily reach the right data. But the more data you store, the more data will come for a similar need. Recommendation Engine have been built for this purpose in the retail industry. Once you get too many options for buying an item, the recommendation engine guides to the right one.

## Design decision

It is not yet the time to replace designers, although we are "sadly" getting closer. Like someone could claim that some people just buy stuff because the recommendation engine tells them to. If we stick to the good values that it could bring in an automated way, we could imagine that it helps for standardizing product design in a company. When you get to select a screw, the recommendation engine could show you which screws have been mostly used for similar designs.

It doesn't have to be just for Parts. What about requirements? A recommendation engine could suggest requirements based on other projects that were done under similar regulations or for a similar client.

Same thing for Manufacturing options, you could accelerate the industrialization process by suggesting manufacturing operations others have used for similar products.

Until we get back to retail recommendations... At some point you will cover the sales configuration of your product. That's where you will meet again with the retail sales configurator, but your configurator engine may be the same for all these purposes if you selected the right stack.

## Graph database

The first time I got into a graph database (maybe around 2013) conference, it seemed like everyone was coming for the same purpose: producing personalized emails for retails website. These IT guys could not produce the amount of email they had to send with the recommendations they wanted to display, on a daily basis. They had document databases and SQL databases. The first type could not handle much traversal queries. The SQL database required larger infrastructure and highly skilled query builders to get some results.

It is just a technical fact. The concept of a graph database makes it much more scalable for traversal queries. You will not be able to support PLM-wide recommendation with anything else than a graph database.

At [Ganister](https://ganister.eu/) we are actually working on it. We will make it easier for anyone to configure a recommendation engine at any stage of your product lifecycle.

Hera are some videos from Neo4j on how to build a recommendation engine:

https://www.youtube.com/watch?v=7sMctFYXW8U&ab\_channel=Neo4j

https://www.youtube.com/watch?v=wbI5JwIFYEM&ab\_channel=WilliamLyon

https://www.youtube.com/watch?v=b\_0Iuc3zUN4&ab\_channel=Neo4j

## AI may be next

Once you get the concept, you may question if you have the right recommendation algorithms in place. It could be then smaller step to allow the recommendation engine to adapt more granularly with each specific context with the help of some artificial intelligence processes. Let's take it one step at a time !
