---
title: "What is an item fork in a graph?"
date: 2021-09-22
categories: 
  - "software-solutions"
tags: 
  - "eco"
  - "plm"
coverImage: "fork.jpg"
---

I'm resuming our series of blog post about configuration management concepts. The last one was about [non-interchangeable revision](https://plmstack.com/2020/05/29/whats-a-non-interchangeable-revision-in-a-graph/). This week we cover the **fork** concept.

## Fork vs Branch

First let's make sure we don't confuse Fork and Branch.

A branch is typically copying data to work on an alternative in order to ultimately merge the benefits of this alternative, back in the initial version. It allows to work on multiple alternatives at the same time.

Fork, is closer to basic configuration management practices. You have a product, and you decide to create a new version. But this version is different enough to not keep the same product number and start a new product reference, not just a revision.

## Fork on PLM data

Historically in PLM, Fork, is copying a folder. Whatever the PLM data you are working on (mechanical, electronic design, or service definition). You create an alternative by copying and renaming a folder.

PLM is a graph, and in a graph, the limits of your folder don't exist. Therefore we need to understand what is the impact of a fork on a few nodes of the PLM graph.

Here is a simple example with PRTC being forked.

<figure>

![](images/fork1.png)

<figcaption>

T0

</figcaption>

</figure>

<figure>

![](images/fork2.png)

<figcaption>

T1

</figcaption>

</figure>

The consequence of such operation is:

- Incoming links are not copied, similar to a non-interchangeable revision
- Outcoming links are copied to keep the same content once you fork.

The difference with a non-interchangeable revision is that you don't supersede the initial part (or any type of node). In our case PRTF starts from the latest state of PRTC but from now on it will live its own life.

The following example is an actual automated test script from [Ganister PLM](https://ganister.eu/). It show that part C1.0 is forked and in the same Engineering Change Order (ECO) D and F are revised (from 1.0 to 1.1) in order to consume the result of the fork. Part C1.0 doesn't change its state. It is still a released Part. Thanks to the graph we easily add a "fork" link to keep the traceability of the fork.

![](images/forkComplex-1024x450.png)

The next step will be to cover the case of a superseding fork. Pretty similar to this fork but changing the state of the former object.

As usual feel free to comment your objections !
