---
title: "What is an ESB and why PLM should care?"
date: 2021-09-29
categories: 
  - "software-solutions"
  - "technological-stack"
coverImage: "ESB.png"
---

Following up on my old article about ETL, another interesting piece of software for a PLM stack is the Enterprise Service Bus. Having a Service Bus in any company department should be the norm. In their daily work people need IT services to support their activities. Remember these User stories you wrote when specifying your application? "As an X I want to Z". Z is the service you are requesting. Then instead of buying a software why don't we buy services? Not software as services but services as services. If your user wants to create a Part with an attached document, you could just buy a service which would allow him to do exactly this and also retrieve and update the created data. Of course, you look for a much bigger picture and PLM has most services you are looking for Out of the box.

# ESB stands for Enterprise Service Bus

So the ESB, will be a transversal view of your services. You can see it as a dictionary of all the services your IT offers to your users, it's the Bus of services for you company. Not only it lists and execute the services you have built, but it can also cascade the services.

#### Example:

**"creating a part of type mechanical should create a CAD document":**

You may have a service called PartCreation and another service called CadDocCreation. You could call them both separately, but on your bus you can add some internal logic to generate sequences of services.

Enterprise Service Bus also ensure the good orchestrations of the services based on your predefined triggers. This triggers can be internal to the bus, like the example we just explained (a part creation triggers a verification of its type and if this is a mechanical part then, a CAD doc is created) but it can be also plugged to external triggers.

#### Example:

**"An email from a supplier with the answer to a Quotation request will trigger a workflow with actions for someone to review it"**

## How does it fit in your PLM environment?

We tend to say that flexible PLMs are the backbone of your company IT. We can say the same thing about the ESB, and actually if you have an ESB, it should become the reference in terms of dictionary of the services existing in your company.

If you don't have yet a complete PLM implementation spread outside the PDM boundaries, you could manage your services with an ESB which would interact with your PLM. Your PLM would become one of the IT solutions which could be triggered by the ESB. If an accounting system needs some information from CAD designs, this accounting service would call a webservice from the ESB and the ESB will do the fetching from the PLM system.

The ESB is usually delivered with ETL capabilities. It makes it easy to connect to each application and each database that contains data needed by the services you will deploy. But it is actually a lot more, it is somehow an application framework, with features like identity management, database federation, request routing,...

![](images/ESB_Component_Hive.png)

## Some existing solutions

Wikipedia has a great list of solutions:

- https://en.wikipedia.org/wiki/Enterprise\_service\_bus#Products

I have actually used and implemented Talend at a large French manufacturing site. It requires a bit more infrastructure knowledge than the ETL but it was fairly easy to get started with a small set of services before growing over time.
